package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

/**
 * Please note: in this enum, CONTEXT is being set
 */
public enum CustomBkOptionsStateMsg implements GettextMsg {
    ACTIVE(msg("Active"), "lib__Application__Model__Product__AN__ContextOnSite__Direct.pm"),
    DELETED(msg("Deleted"), "lib__Application__Model__DSP.pm");

    private final GettextMsgPayload payload;
    private final String keyset;

    CustomBkOptionsStateMsg(GettextMsgPayload.Builder payload, String keyset) {
        this.payload = payload.build();
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
