package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum DspCaptionMsg implements GettextMsg {
    MEDIA_ADVERTISING(msg("Media advertising")),
    VIDEO_ADVERTISING(msg("Video advertising")),
    MOBILE_ADVERTISING(msg("Mobile advertising"));

    private static final String KEYSET_NAME = "lib__Application__Model__DSP.pm";

    private final GettextMsgPayload payload;
    private final String keyset;

    DspCaptionMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
        this.keyset = KEYSET_NAME;
    }

    DspCaptionMsg(GettextMsgPayload.Builder builder, String keyset) {
        this.payload = builder.build();
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
