package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum DspStateMsg implements GettextMsg {
    NEW(msg("New"), "lib__Application__Model__Users.pm"), // no context was in Perl
    CREATED_IN_BK(msg("Created in BK")),
    CREATED_IN_PI(msg("Task's created in PI")),
    LINKED_IN_BALANCE(msg("Linked in Balance")),
    WORKING(msg("DSP is working")),
    NEED_APPROVE(msg("Need approve DSP")),
    EDITED(msg("Edited DSP")),
    DELETED(msg("Deleted")),
    WORKING_ON_ALL_PLATFORMS(msg("Working on all platforms")),
    WORKING_ON_YANDEX_SERVICES(msg("Working on Yandex services")),
    NEED_CREATE_IN_PI(msg("Need create in PI")),
    NOT_NEED_CREATE_IN_PI(msg("Not need create in PI"));
    
    private static final String KEYSET_NAME = "lib__Application__Model__DSP.pm";

    private final GettextMsgPayload payload;
    private final String keyset;

    DspStateMsg(GettextMsgPayload.Builder builder, String keyset) {
        this.payload = builder.build();
        this.keyset = keyset;
    }

    DspStateMsg(GettextMsgPayload.Builder builder) {
        this(builder, KEYSET_NAME);
    }


    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }

}
