package ru.yandex.partner.core.messages;

import org.jetbrains.annotations.NotNull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum GeoBaseMsg implements GettextMsg {

    OWNER_NOT_FOUND(msg("Owner not found"), "lib__Application__Model__GeoBase.pm");

    private final GettextMsgPayload payload;
    private final String keyset;

    GeoBaseMsg(GettextMsgPayload.Builder builder, String keyset) {
        this.payload = builder.build();
        this.keyset = keyset;
    }

    @NotNull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @NotNull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
