package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum MirrorStateMsg implements GettextMsg {
    NEW(msg("New")),
    APPROVED(msg("Approved")),
    REJECTED(msg("Rejected")),
    DELETED(msg("Deleted"));

    private static final String CONTEXT = "Mirror multistate";
    private static final String KEYSET_NAME =
            "lib__Application__Model__Product__AN__ContextOnSite__Campaign__Mirrors.pm";

    private final GettextMsgPayload payload;

    MirrorStateMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder
                .context(CONTEXT)
                .build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }
}
