package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum PageStateMsg implements GettextMsg {
    NEW(msg("New"), "lib__Application__Model__Users.pm"), // no context was in Perl
    WORKING(msg("Working").context(Constants.CONTEXT), Constants.INTERNAL_AN_INTERNAL_SEARCH_ON_SITE),
    TESTING(msg("Testing").context(Constants.CONTEXT), Constants.INTERNAL_AN_INTERNAL_SEARCH_ON_SITE),
    STOPPED(msg("Stopped").context(Constants.CONTEXT), Constants.INTERNAL_AN_INTERNAL_SEARCH_ON_SITE),
    ARCHIVED(msg("Archived").context(Constants.CONTEXT), Constants.INTERNAL_AN_INTERNAL_SEARCH_ON_SITE),
    ADDED_TO_BALANCE(msg("Added to Balance").context(Constants.CONTEXT),
            Constants.INTERNAL_AN_INTERNAL_SEARCH_ON_SITE),
    READ_ONLY(msg("Read only").context(Constants.CONTEXT), Constants.INTERNAL_AN_INTERNAL_SEARCH_ON_SITE),
    CHECK_STATISTICS(msg("Check statistics").context(Constants.CONTEXT), Constants.INTERNAL_AN_INTERNAL_SEARCH_ON_SITE),
    BLOCKED(msg("Blocked").context(Constants.CONTEXT), Constants.AN_CONTEXT_ON_SITE),
    NEED_APPROVE(msg("Need approve").context(Constants.CONTEXT), Constants.AN_CONTEXT_ON_SITE),
    REJECTED(msg("Rejected").context(Constants.CONTEXT), Constants.AN_CONTEXT_ON_SITE),
    PROTECTED(msg("Protected").context(Constants.CONTEXT), Constants.AN_CONTEXT_ON_SITE),
    NEED_UPDATE(msg("Need update").context(Constants.CONTEXT), Constants.AN_CONTEXT_ON_SITE),
    UPDATING(msg("Updating").context(Constants.CONTEXT), Constants.AN_CONTEXT_ON_SITE),
    CREATED_IN_MEDIAPRODUCTS(msg("Created in \"mediaproducts\"").context(Constants.SETTINGS_CONTEXT),
            "lib__Application__Model__Product__AN__MobileApp__Settings.pm"),
    APPROVED(msg("Approved").context("Application status"), "lib__Application__Model__Product__AN__MobileApp.pm");


    private final GettextMsgPayload payload;
    private final String keyset;

    PageStateMsg(GettextMsgPayload.Builder builder, String keyset) {
        this.payload = builder.build();
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }

    private static class Constants {
        private static final String CONTEXT = "Campaign status";
        private static final String SETTINGS_CONTEXT = "Settings status";
        public static final String INTERNAL_AN_INTERNAL_SEARCH_ON_SITE =
                "lib__Application__Model__Product__InternalAN__InternalSearchOnSite__Campaign.pm";
        public static final String AN_CONTEXT_ON_SITE =
                "lib__Application__Model__Product__AN__ContextOnSite__Campaign.pm";
    }
}
