package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum TaskStateMsg implements GettextMsg {
    NEW(msg("New"), "lib__Application__Model__Users.pm"),
    WORKING(msg("Working")),
    CANCELED(msg("Canceled")),
    FINISHED_WITH_SUCCESS(msg("Successfully finished")),
    FINISHED_WITH_ERROR(msg("Finished with error")),
    NEED_RESTART(msg("Need restart"));

    private static final String KEYSET_NAME = "lib__Application__Model__Queue.pm";

    private final GettextMsgPayload payload;
    private final String keyset;

    TaskStateMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
        this.keyset = KEYSET_NAME;
    }

    TaskStateMsg(GettextMsgPayload.Builder builder, String keyset) {
        this.payload = builder.build();
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
