package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum TaskTypeMsg implements GettextMsg {
    STATISTICS_UPDATE(msg("Statistics update"), "lib__WebInterface.pm"),
    UPDATE_IN_BK(msg("Update in BK")),
    DB_DUMP(msg("DB dump")),
    UPDATE_MOBILE_APP_STATUS(msg("Update MobileApp status")),
    MARK_READ_FNS_NOTIFICATION(msg("Mark read FNS notification")),
    SEND_EMAIL_TO_PROCESSING(msg("Send email to processing"));

    private static final String KEYSET_NAME = "lib__Application__Model__Queue.pm";

    private final GettextMsgPayload payload;
    private final String keyset;

    TaskTypeMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
        this.keyset = KEYSET_NAME;
    }

    TaskTypeMsg(GettextMsgPayload.Builder builder, String keyset) {
        this.payload = builder.build();
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
