package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum UserStateMsg implements GettextMsg {
    NEW(msg("New")),
    CONTACTS_PROVIDED(msg("Contacts provided")),
    NEED_CREATE_IN_BANNER_STORE(msg("Need create partner in BannerStore")),
    NEED_YAN_CONTRACT(msg("Need YAN contract")),
    BLOCKED(msg("User blocked"));

    private static final String KEYSET_NAME = "lib__Application__Model__Users.pm";

    private final GettextMsgPayload payload;

    UserStateMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }

}
