package ru.yandex.partner.core.modelmeta;

import java.util.List;
import java.util.stream.Collectors;

import org.reflections.Reflections;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.modelmeta.annotation.ModelMeta;

public class ModelMetaCollector {
    private ModelMetaCollector() {
    }

    public static List<ModelMetaHolder> getModelMetaHolders() {
        Reflections reflections = new Reflections("ru.yandex.partner.core.entity");

        List<Class<? extends ModelWithId>> classesWithModelMetaAnnotation = reflections.getSubTypesOf(ModelWithId.class)
                .stream().filter(c -> c.isAnnotationPresent(ModelMeta.class)).collect(Collectors.toList());

        return classesWithModelMetaAnnotation.stream().map(entityClass -> {
            ModelMeta modelMeta = entityClass.getAnnotation(ModelMeta.class);

            return new ModelMetaHolder(modelMeta, entityClass);
        }).collect(Collectors.toList());
    }
}
