package ru.yandex.partner.core.multistate;

import java.util.List;
import java.util.Map;

import ru.yandex.partner.libs.i18n.GettextMsg;

public interface Multistate<T extends StateFlag> {
    boolean hasFlag(T flag);

    boolean test(T flag);

    void setFlags(Map<T, Boolean> values);

    default void setFlag(T flag, boolean value) {
        setFlags(Map.of(flag, value));
    }

    List<T> getEnabledFlags();

    long toMultistateValue();

    List<GettextMsg> getNameMessages();

    Multistate<T> copy();
}
