package ru.yandex.partner.core.multistate;

import java.util.function.Predicate;

import ru.yandex.partner.libs.i18n.GettextMsg;

public interface StateFlag<T extends StateFlag> extends Predicate<Multistate<T>> {
    GettextMsg getMsg();

    boolean isPrivate();

    @Override
    default boolean test(Multistate<T> ms) {
        return ms.hasFlag((T) this);
    }
}
