package ru.yandex.partner.core.multistate.block;

import java.util.List;
import java.util.Optional;

import ru.yandex.partner.core.messages.BlockStateMsg;
import ru.yandex.partner.core.multistate.AbstractMultistate;
import ru.yandex.partner.libs.i18n.GettextMsg;

public class BlockMultistate extends AbstractMultistate<BlockStateFlag> {
    private static final List<Optional<BlockStateFlag>> STATE_FLAGS_IN_ORDER = List.of(
            Optional.of(BlockStateFlag.DELETED),
            Optional.of(BlockStateFlag.WORKING),
            Optional.of(BlockStateFlag.CHECK_STATISTICS),
            Optional.of(BlockStateFlag.DELETED_WITH_PAGE),
            Optional.of(BlockStateFlag.NEED_UPDATE),
            Optional.of(BlockStateFlag.UPDATING)
    );

    private static final GettextMsg EMPTY_MESSAGE = BlockStateMsg.NEW;

    public BlockMultistate(long multistateValue) {
        super(multistateValue);
    }

    public BlockMultistate() {
        super();
    }

    public BlockMultistate(List<BlockStateFlag> enabledFlags) {
        super(enabledFlags);
    }

    @Override
    protected List<Optional<BlockStateFlag>> getStateFlags() {
        return STATE_FLAGS_IN_ORDER;
    }

    @Override
    protected GettextMsg getEmptyMessage() {
        return EMPTY_MESSAGE;
    }

    @Override
    public BlockMultistate copy() {
        return new BlockMultistate(toMultistateValue());
    }

    public static List<Optional<BlockStateFlag>> getStateFlagsInOrder() {
        return STATE_FLAGS_IN_ORDER;
    }
}
