package ru.yandex.partner.core.multistate.block;

import ru.yandex.partner.core.messages.BlockStateMsg;
import ru.yandex.partner.core.multistate.StateFlag;
import ru.yandex.partner.libs.i18n.GettextMsg;

public enum BlockStateFlag implements StateFlag<BlockStateFlag> {
    DELETED(BlockStateMsg.ARCHIVED),
    WORKING(BlockStateMsg.WORKING),
    CHECK_STATISTICS(BlockStateMsg.CHECK_STATISTICS),
    DELETED_WITH_PAGE(BlockStateMsg.ARCHIVED_WITH_PAGE, true),
    NEED_UPDATE(BlockStateMsg.NEED_UPDATE),
    UPDATING(BlockStateMsg.UPDATING);

    private final GettextMsg msg;
    private final boolean isPrivate;

    BlockStateFlag(GettextMsg msg) {
        this(msg, false);
    }

    BlockStateFlag(GettextMsg msg, boolean isPrivate) {
        this.msg = msg;
        this.isPrivate = isPrivate;
    }

    @Override
    public GettextMsg getMsg() {
        return msg;
    }

    @Override
    public boolean isPrivate() {
        return isPrivate;
    }
}
