package ru.yandex.partner.core.multistate.custombkoptions;

import java.util.List;
import java.util.Optional;

import ru.yandex.partner.core.messages.CustomBkOptionsStateMsg;
import ru.yandex.partner.core.multistate.AbstractMultistate;
import ru.yandex.partner.core.multistate.Multistate;
import ru.yandex.partner.libs.i18n.GettextMsg;

public class CustomBkOptionsMultistate extends AbstractMultistate<CustomBkOptionsStateFlag> {
    private static final List<Optional<CustomBkOptionsStateFlag>> STATE_FLAGS_IN_ORDER = List.of(
            Optional.of(CustomBkOptionsStateFlag.DELETED)
    );

    public CustomBkOptionsMultistate(long multistateValue) {
        super(multistateValue);
    }

    public CustomBkOptionsMultistate(List<CustomBkOptionsStateFlag> enabledFlags) {
        super(enabledFlags);
    }

    public CustomBkOptionsMultistate() {
        super();
    }

    @Override
    protected List<Optional<CustomBkOptionsStateFlag>> getStateFlags() {
        return STATE_FLAGS_IN_ORDER;
    }

    @Override
    protected GettextMsg getEmptyMessage() {
        return CustomBkOptionsStateMsg.ACTIVE;
    }

    @Override
    public Multistate<CustomBkOptionsStateFlag> copy() {
        return new CustomBkOptionsMultistate(toMultistateValue());
    }
}
