package ru.yandex.partner.core.multistate.designtemplates;

import java.util.List;
import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.core.messages.BlockStateMsg;
import ru.yandex.partner.core.multistate.AbstractMultistate;
import ru.yandex.partner.libs.i18n.GettextMsg;

@ParametersAreNonnullByDefault
public class DesignTemplatesMultistate extends AbstractMultistate<DesignTemplatesStateFlag> {
    private static final List<Optional<DesignTemplatesStateFlag>> STATE_FLAGS_IN_ORDER = List.of(
            Optional.of(DesignTemplatesStateFlag.DELETED)
    );
    private static final GettextMsg EMPTY_MESSAGE = BlockStateMsg.NEW;

    public DesignTemplatesMultistate(long multistateValue) {
        super(multistateValue);
    }

    public DesignTemplatesMultistate() {
        super();
    }

    public DesignTemplatesMultistate(List<DesignTemplatesStateFlag> enabledFlags) {
        super(enabledFlags);
    }

    public static List<Optional<DesignTemplatesStateFlag>> getStateFlagsInOrder() {
        return STATE_FLAGS_IN_ORDER;
    }

    @Override
    protected List<Optional<DesignTemplatesStateFlag>> getStateFlags() {
        return STATE_FLAGS_IN_ORDER;
    }

    @Override
    protected GettextMsg getEmptyMessage() {
        return EMPTY_MESSAGE;
    }

    @Override
    public DesignTemplatesMultistate copy() {
        return new DesignTemplatesMultistate(toMultistateValue());
    }
}
