package ru.yandex.partner.core.multistate.designtemplates;

import ru.yandex.partner.core.messages.BlockStateMsg;
import ru.yandex.partner.core.multistate.StateFlag;
import ru.yandex.partner.libs.i18n.GettextMsg;

public enum DesignTemplatesStateFlag implements StateFlag<DesignTemplatesStateFlag> {
    DELETED(BlockStateMsg.ARCHIVED);

    private final GettextMsg msg;
    private final boolean isPrivate;

    DesignTemplatesStateFlag(GettextMsg msg) {
        this(msg, false);
    }

    DesignTemplatesStateFlag(GettextMsg msg, boolean isPrivate) {
        this.msg = msg;
        this.isPrivate = isPrivate;
    }

    @Override
    public GettextMsg getMsg() {
        return msg;
    }

    @Override
    public boolean isPrivate() {
        return isPrivate;
    }
}
