package ru.yandex.partner.core.multistate.dsp;

import java.util.List;
import java.util.Optional;

import ru.yandex.partner.core.messages.DspStateMsg;
import ru.yandex.partner.core.multistate.AbstractMultistate;
import ru.yandex.partner.libs.i18n.GettextMsg;

public class DspMultistate extends AbstractMultistate<DspStateFlag> {
    private static final List<Optional<DspStateFlag>> STATE_FLAGS_IN_ORDER = List.of(
            Optional.of(DspStateFlag.CREATED_IN_BK),
            Optional.of(DspStateFlag.CREATED_IN_PI),
            Optional.of(DspStateFlag.LINKED_IN_BALANCE),
            Optional.of(DspStateFlag.WORKING),
            Optional.of(DspStateFlag.NEED_APPROVE),
            Optional.of(DspStateFlag.EDITED),
            Optional.of(DspStateFlag.DELETED),
            Optional.of(DspStateFlag.WORKING_ON_ALL_PLATFORMS),
            Optional.of(DspStateFlag.WORKING_ON_YANDEX_SERVICES),
            Optional.of(DspStateFlag.NEED_CREATE_IN_PI),
            Optional.of(DspStateFlag.NOT_NEED_CREATE_IN_PI)
    );

    private static final GettextMsg EMPTY_MESSAGE = DspStateMsg.NEW;

    public DspMultistate(long multistateValue) {
        super(multistateValue);
    }

    public DspMultistate() {
        super();
    }

    public DspMultistate(List<DspStateFlag> enabledFlags) {
        super(enabledFlags);
    }

    @Override
    protected List<Optional<DspStateFlag>> getStateFlags() {
        return STATE_FLAGS_IN_ORDER;
    }

    @Override
    protected GettextMsg getEmptyMessage() {
        return EMPTY_MESSAGE;
    }

    @Override
    public DspMultistate copy() {
        return new DspMultistate(toMultistateValue());
    }

    public static List<Optional<DspStateFlag>> getStateFlagsInOrder() {
        return STATE_FLAGS_IN_ORDER;
    }
}
