package ru.yandex.partner.core.multistate.dsp;

import ru.yandex.partner.core.messages.DspStateMsg;
import ru.yandex.partner.core.multistate.StateFlag;
import ru.yandex.partner.libs.i18n.GettextMsg;

public enum DspStateFlag implements StateFlag<DspStateFlag> {
    CREATED_IN_BK(DspStateMsg.CREATED_IN_BK),
    CREATED_IN_PI(DspStateMsg.CREATED_IN_PI),
    LINKED_IN_BALANCE(DspStateMsg.LINKED_IN_BALANCE),
    WORKING(DspStateMsg.WORKING),
    NEED_APPROVE(DspStateMsg.NEED_APPROVE),
    EDITED(DspStateMsg.EDITED),
    DELETED(DspStateMsg.DELETED),
    WORKING_ON_ALL_PLATFORMS(DspStateMsg.WORKING_ON_ALL_PLATFORMS),
    WORKING_ON_YANDEX_SERVICES(DspStateMsg.WORKING_ON_YANDEX_SERVICES),
    NEED_CREATE_IN_PI(DspStateMsg.NEED_CREATE_IN_PI),
    NOT_NEED_CREATE_IN_PI(DspStateMsg.NOT_NEED_CREATE_IN_PI);

    private final GettextMsg msg;
    private final boolean isPrivate;

    DspStateFlag(GettextMsg msg) {
        this(msg, false);
    }

    DspStateFlag(GettextMsg msg, boolean isPrivate) {
        this.msg = msg;
        this.isPrivate = isPrivate;
    }

    @Override
    public GettextMsg getMsg() {
        return msg;
    }

    @Override
    public boolean isPrivate() {
        return isPrivate;
    }
}
