package ru.yandex.partner.core.multistate.mirror;

import java.util.List;
import java.util.Optional;

import ru.yandex.partner.core.messages.MirrorStateMsg;
import ru.yandex.partner.core.multistate.AbstractMultistate;
import ru.yandex.partner.core.multistate.Multistate;
import ru.yandex.partner.libs.i18n.GettextMsg;

public class MirrorMultistate extends AbstractMultistate<MirrorStateFlag> {
    private static final List<Optional<MirrorStateFlag>> STATE_FLAGS_IN_ORDER = List.of(
            Optional.of(MirrorStateFlag.APPROVED),
            Optional.of(MirrorStateFlag.REJECTED),
            Optional.of(MirrorStateFlag.DELETED)
    );

    public MirrorMultistate(long multistateValue) {
        super(multistateValue);
    }

    public MirrorMultistate(List<MirrorStateFlag> enabledFlags) {
        super(enabledFlags);
    }

    public MirrorMultistate() {
        super();
    }

    @Override
    protected List<Optional<MirrorStateFlag>> getStateFlags() {
        return STATE_FLAGS_IN_ORDER;
    }

    @Override
    protected GettextMsg getEmptyMessage() {
        return MirrorStateMsg.NEW;
    }

    @Override
    public Multistate<MirrorStateFlag> copy() {
        return new MirrorMultistate(toMultistateValue());
    }
}
