package ru.yandex.partner.core.multistate.mirror;

import ru.yandex.partner.core.messages.MirrorStateMsg;
import ru.yandex.partner.core.multistate.StateFlag;
import ru.yandex.partner.libs.i18n.GettextMsg;

public enum  MirrorStateFlag implements StateFlag<MirrorStateFlag> {
    APPROVED(MirrorStateMsg.APPROVED),
    REJECTED(MirrorStateMsg.REJECTED),
    DELETED(MirrorStateMsg.DELETED);

    private final GettextMsg msg;
    private final boolean isPrivate;

    MirrorStateFlag(GettextMsg msg) {
        this.msg = msg;
        this.isPrivate = false;
    }

    @Override
    public GettextMsg getMsg() {
        return msg;
    }

    @Override
    public boolean isPrivate() {
        return isPrivate;
    }
}
