package ru.yandex.partner.core.multistate.page;

import java.util.List;
import java.util.Optional;

import ru.yandex.partner.core.messages.PageStateMsg;
import ru.yandex.partner.libs.i18n.GettextMsg;

import static ru.yandex.partner.core.multistate.page.PageStateFlag.BALANCE_REGISTERED;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.BLOCKED;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.CHECK_STATISTICS;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.DELETED;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.NEED_APPROVE;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.NEED_UPDATE;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.PROTECTED;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.READ_ONLY;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.REJECTED;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.STOPPED;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.TESTING;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.UPDATING;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.WORKING;

public class ContextPageMultistate extends PageMultistate {
    private static final List<Optional<PageStateFlag>> STATE_FLAGS_IN_ORDER = List.of(
            Optional.of(WORKING),
            Optional.of(TESTING),
            Optional.of(STOPPED),
            Optional.of(DELETED),
            Optional.of(BALANCE_REGISTERED),
            Optional.of(READ_ONLY),
            Optional.of(CHECK_STATISTICS),
            Optional.of(BLOCKED),
            Optional.of(NEED_APPROVE),
            Optional.of(REJECTED),
            Optional.of(PROTECTED),
            Optional.of(NEED_UPDATE),
            Optional.of(UPDATING)
    );

    public ContextPageMultistate(long multistateValue) {
        super(multistateValue);
    }

    public ContextPageMultistate() {
        super();
    }

    public ContextPageMultistate(List<PageStateFlag> enabledFlags) {
        super(enabledFlags);
    }

    @Override
    protected List<Optional<PageStateFlag>> getStateFlags() {
        return STATE_FLAGS_IN_ORDER;
    }

    @Override
    protected GettextMsg getEmptyMessage() {
        return PageStateMsg.NEW;
    }

    @Override
    public ContextPageMultistate internalCopy() {
        return new ContextPageMultistate(toMultistateValue());
    }
}
