package ru.yandex.partner.core.multistate.page;

import java.util.List;
import java.util.Optional;

import ru.yandex.partner.core.messages.PageStateMsg;
import ru.yandex.partner.libs.i18n.GettextMsg;

public class InternalContextPageMultistate extends PageMultistate {
    private static final List<Optional<PageStateFlag>> STATE_FLAGS_IN_ORDER = List.of(
            Optional.of(PageStateFlag.WORKING),
            Optional.of(PageStateFlag.TESTING),
            Optional.of(PageStateFlag.STOPPED),
            Optional.of(PageStateFlag.DELETED),
            Optional.of(PageStateFlag.BALANCE_REGISTERED),
            Optional.of(PageStateFlag.READ_ONLY),
            Optional.of(PageStateFlag.CHECK_STATISTICS),
            Optional.of(PageStateFlag.PROTECTED),
            Optional.of(PageStateFlag.NEED_UPDATE),
            Optional.of(PageStateFlag.UPDATING)
    );

    public InternalContextPageMultistate(long multistateValue) {
        super(multistateValue);
    }

    public InternalContextPageMultistate() {
        super();
    }

    public InternalContextPageMultistate(List<PageStateFlag> enabledFlags) {
        super(enabledFlags);
    }

    @Override
    protected List<Optional<PageStateFlag>> getStateFlags() {
        return STATE_FLAGS_IN_ORDER;
    }

    @Override
    protected GettextMsg getEmptyMessage() {
        return PageStateMsg.NEW;
    }

    @Override
    public PageMultistate internalCopy() {
        return new InternalContextPageMultistate(toMultistateValue());
    }
}
