package ru.yandex.partner.core.multistate.page;

import java.util.List;
import java.util.Optional;

import ru.yandex.partner.core.messages.PageStateMsg;
import ru.yandex.partner.libs.i18n.GettextMsg;

import static ru.yandex.partner.core.multistate.page.PageStateFlag.CHECK_STATISTICS;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.DELETED;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.NEED_UPDATE;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.PROTECTED;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.STOPPED;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.UPDATING;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.WORKING;

public class InternalMobileAppMultistate extends PageMultistate {
    private static final List<Optional<PageStateFlag>> STATE_FLAGS_IN_ORDER = List.of(
            Optional.of(WORKING),
            Optional.empty(), // TESTING deprecated
            Optional.of(STOPPED),
            Optional.of(DELETED),
            Optional.of(CHECK_STATISTICS),
            Optional.of(PROTECTED),
            Optional.of(NEED_UPDATE),
            Optional.of(UPDATING)
    );

    public InternalMobileAppMultistate(long multistateValue) {
        super(multistateValue);
    }

    public InternalMobileAppMultistate(List<PageStateFlag> enabledFlags) {
        super(enabledFlags);
    }

    @Override
    protected List<Optional<PageStateFlag>> getStateFlags() {
        return STATE_FLAGS_IN_ORDER;
    }

    @Override
    protected GettextMsg getEmptyMessage() {
        return PageStateMsg.NEW;
    }

    @Override
    public PageMultistate internalCopy() {
        return new InternalMobileAppMultistate(toMultistateValue());
    }

    public static List<Optional<PageStateFlag>> getStateFlagsInOrder() {
        return STATE_FLAGS_IN_ORDER;
    }
}
