package ru.yandex.partner.core.multistate.page;

import java.util.List;
import java.util.Optional;

import ru.yandex.partner.core.messages.PageStateMsg;
import ru.yandex.partner.libs.i18n.GettextMsg;

import static ru.yandex.partner.core.multistate.page.PageStateFlag.APPROVED;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.NEED_APPROVE;
import static ru.yandex.partner.core.multistate.page.PageStateFlag.REJECTED;

public class MobileAppMultistate extends PageMultistate {
    private static final List<Optional<PageStateFlag>> STATE_FLAGS_IN_ORDER = List.of(
            Optional.of(NEED_APPROVE),
            Optional.of(REJECTED),
            Optional.of(APPROVED)
    );

    public MobileAppMultistate(long multistateValue) {
        super(multistateValue);
    }

    public MobileAppMultistate(List<PageStateFlag> enabledFlags) {
        super(enabledFlags);
    }

    @Override
    protected List<Optional<PageStateFlag>> getStateFlags() {
        return STATE_FLAGS_IN_ORDER;
    }

    @Override
    protected GettextMsg getEmptyMessage() {
        return PageStateMsg.NEW;
    }

    @Override
    public PageMultistate internalCopy() {
        return new MobileAppMultistate(toMultistateValue());
    }
}
