package ru.yandex.partner.core.multistate.page;

import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.partner.core.messages.PageStateMsg;
import ru.yandex.partner.core.multistate.StateFlag;
import ru.yandex.partner.libs.i18n.GettextMsg;

public enum PageStateFlag implements StateFlag<PageStateFlag> {
    WORKING(PageStateMsg.WORKING),
    TESTING(PageStateMsg.TESTING),
    STOPPED(PageStateMsg.STOPPED),
    DELETED(msg(PageStateMsg.ARCHIVED).asPrivate().inactive()),
    BALANCE_REGISTERED(msg(PageStateMsg.ADDED_TO_BALANCE).asPrivate()),
    READ_ONLY(msg(PageStateMsg.READ_ONLY).asPrivate()),
    CHECK_STATISTICS(msg(PageStateMsg.CHECK_STATISTICS).asPrivate()),
    BLOCKED(msg(PageStateMsg.BLOCKED).inactive()),
    NEED_APPROVE(msg(PageStateMsg.NEED_APPROVE)),
    REJECTED(msg(PageStateMsg.REJECTED).inactive()),
    PROTECTED(msg(PageStateMsg.PROTECTED)),
    NEED_UPDATE(PageStateMsg.NEED_UPDATE),
    UPDATING(PageStateMsg.UPDATING),
    CREATED_IN_MEDIAPRODUCTS(msg(PageStateMsg.CREATED_IN_MEDIAPRODUCTS).asPrivate()),
    APPROVED(PageStateMsg.UPDATING);

    public static final Set<PageStateFlag> INACTIVE_STATES =
            EnumSet.copyOf(
                    EnumSet.allOf(PageStateFlag.class).stream()
                            .filter(it -> !it.isActive)
                            .collect(Collectors.toSet())
            );

    private final GettextMsg msg;
    private final boolean isPrivate;
    private final boolean isActive;

    PageStateFlag(GettextMsg msg) {
        this(msg(msg));
    }

    PageStateFlag(GettextMsg msg, boolean isPrivate, boolean isActive) {
        this.msg = msg;
        this.isPrivate = isPrivate;
        this.isActive = isActive;
    }

    PageStateFlag(Builder b) {
        this(b.msg, b.isPrivate, b.isActive);
    }

    @Override
    public GettextMsg getMsg() {
        return msg;
    }

    @Override
    public boolean isPrivate() {
        return isPrivate;
    }

    private static Builder msg(GettextMsg msg) {
        return new Builder(msg);
    }

    static class Builder {
        final GettextMsg msg;
        boolean isActive = true;
        boolean isPrivate = false;

        Builder(GettextMsg msg) {
            this.msg = msg;
        }

        Builder asPrivate() {
            this.isPrivate = true;
            return this;
        }

        Builder inactive() {
            this.isActive = false;
            return this;
        }
    }
}
