package ru.yandex.partner.core.multistate.queue;

import java.util.List;
import java.util.Optional;

import ru.yandex.partner.core.messages.TaskStateMsg;
import ru.yandex.partner.core.multistate.AbstractMultistate;
import ru.yandex.partner.libs.i18n.GettextMsg;

public class TaskMultistate extends AbstractMultistate<TaskStateFlag> {
    private static final List<Optional<TaskStateFlag>> STATE_FLAGS_IN_ORDER = List.of(
            Optional.of(TaskStateFlag.WORKING),
            Optional.of(TaskStateFlag.CANCELED),
            Optional.of(TaskStateFlag.FINISHED_WITH_SUCCESS),
            Optional.of(TaskStateFlag.FINISHED_WITH_ERROR),
            Optional.of(TaskStateFlag.NEED_RESTART)
    );

    private static final GettextMsg EMPTY_MESSAGE = TaskStateMsg.NEW;

    public TaskMultistate(long multistateValue) {
        super(multistateValue);
    }

    public TaskMultistate() {
        super();
    }

    public TaskMultistate(List<TaskStateFlag> enabledFlags) {
        super(enabledFlags);
    }

    @Override
    protected List<Optional<TaskStateFlag>> getStateFlags() {
        return STATE_FLAGS_IN_ORDER;
    }

    @Override
    protected GettextMsg getEmptyMessage() {
        return EMPTY_MESSAGE;
    }

    @Override
    public TaskMultistate copy() {
        return new TaskMultistate(toMultistateValue());
    }

    public static List<Optional<TaskStateFlag>> getStateFlagsInOrder() {
        return STATE_FLAGS_IN_ORDER;
    }

}
