package ru.yandex.partner.core.multistate.queue;

import ru.yandex.partner.core.messages.TaskStateMsg;
import ru.yandex.partner.core.multistate.StateFlag;
import ru.yandex.partner.libs.i18n.GettextMsg;

public enum TaskStateFlag implements StateFlag<TaskStateFlag> {
    WORKING(TaskStateMsg.WORKING),
    CANCELED(TaskStateMsg.CANCELED),
    FINISHED_WITH_ERROR(TaskStateMsg.FINISHED_WITH_ERROR),
    FINISHED_WITH_SUCCESS(TaskStateMsg.FINISHED_WITH_SUCCESS),
    NEED_RESTART(TaskStateMsg.NEED_RESTART);

    private final GettextMsg msg;
    private final boolean isPrivate;

    TaskStateFlag(GettextMsg msg) {
        this(msg, false);
    }

    TaskStateFlag(GettextMsg msg, boolean isPrivate) {
        this.msg = msg;
        this.isPrivate = isPrivate;
    }

    @Override
    public GettextMsg getMsg() {
        return msg;
    }

    @Override
    public boolean isPrivate() {
        return isPrivate;
    }
}
