package ru.yandex.partner.core.multistate.user;

import java.util.List;
import java.util.Optional;

import ru.yandex.partner.core.messages.UserStateMsg;
import ru.yandex.partner.core.multistate.AbstractMultistate;
import ru.yandex.partner.libs.i18n.GettextMsg;

public class UserMultistate extends AbstractMultistate<UserStateFlag> {
    private static final List<Optional<UserStateFlag>> STATE_FLAGS_IN_ORDER = List.of(
            Optional.of(UserStateFlag.CONTACTS_PROVIDED),
            Optional.of(UserStateFlag.NEED_CREATE_IN_BANNER_STORE),
            Optional.empty(),
            Optional.of(UserStateFlag.NEED_YAN_CONTRACT),
            Optional.of(UserStateFlag.BLOCKED)
    );

    private static final GettextMsg EMPTY_MESSAGE = UserStateMsg.NEW;

    public UserMultistate(long multistateValue) {
        super(multistateValue);
    }

    public UserMultistate() {
        super();
    }

    public UserMultistate(List<UserStateFlag> enabledFlags) {
        super(enabledFlags);
    }

    @Override
    protected List<Optional<UserStateFlag>> getStateFlags() {
        return STATE_FLAGS_IN_ORDER;
    }

    @Override
    protected GettextMsg getEmptyMessage() {
        return EMPTY_MESSAGE;
    }

    @Override
    public UserMultistate copy() {
        return new UserMultistate(toMultistateValue());
    }

    public static List<Optional<UserStateFlag>> getStateFlagsInOrder() {
        return STATE_FLAGS_IN_ORDER;
    }
}
