package ru.yandex.partner.core.multistate.user;

import ru.yandex.partner.core.messages.UserStateMsg;
import ru.yandex.partner.core.multistate.StateFlag;
import ru.yandex.partner.libs.i18n.GettextMsg;

public enum UserStateFlag implements StateFlag<UserStateFlag> {
    CONTACTS_PROVIDED(UserStateMsg.CONTACTS_PROVIDED),
    NEED_CREATE_IN_BANNER_STORE(UserStateMsg.NEED_CREATE_IN_BANNER_STORE),
    NEED_YAN_CONTRACT(UserStateMsg.NEED_YAN_CONTRACT),
    BLOCKED(UserStateMsg.BLOCKED);

    private final GettextMsg msg;
    private final boolean isPrivate;

    UserStateFlag(GettextMsg msg) {
        this(msg, false);
    }

    UserStateFlag(GettextMsg msg, boolean isPrivate) {
        this.msg = msg;
        this.isPrivate = isPrivate;
    }

    @Override
    public GettextMsg getMsg() {
        return msg;
    }

    @Override
    public boolean isPrivate() {
        return isPrivate;
    }
}
