package ru.yandex.partner.core.page;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum MobileStoreType {
    ANDROID(1L, "Android", "GooglePlay"),
    IOS(2L, "iOS", "AppStore");

    private static final Map<Long, MobileStoreType> ID_MAP =
            Arrays.stream(values()).collect(Collectors.toMap(MobileStoreType::getId, Function.identity()));

    private final Long id;
    private final String caption;
    private final String store;

    MobileStoreType(Long id, String caption, String store) {
        this.id = id;
        this.caption = caption;
        this.store = store;
    }

    public static MobileStoreType getById(Long id) {
        var value = ID_MAP.get(id);

        if (value == null) {
            throw new IllegalArgumentException("No mobile store type with id %s".formatted(id));
        }

        return value;
    }

    public String getCaption() {
        return caption;
    }

    public String getStore() {
        return store;
    }

    public Long getId() {
        return id;
    }
}
