package ru.yandex.partner.core.page

import org.springframework.stereotype.Component
import ru.yandex.partner.core.entity.page.model.BasePage
import ru.yandex.partner.core.modelmeta.ModelMetaCollector
import ru.yandex.partner.core.modelmeta.ModelTypesHolder
import ru.yandex.partner.dbschema.partner.enums.PagesModel

@Component
class PageModelTypesHolder(
    private val mapping: Map<Class<out BasePage>, PagesModel>
    = ModelMetaCollector.getModelMetaHolders()
        .filter { BasePage::class.java.isAssignableFrom(it.entityClass) }.associate {
            @Suppress("UNCHECKED_CAST")
            it.entityClass as Class<out BasePage> to PagesModel.valueOf(it.name)
        }
) :
    ModelTypesHolder<BasePage, PagesModel> {

    override fun getTypeForDb(clazz: Class<out BasePage>): PagesModel? {
        return mapping[clazz]
    }
}
