package ru.yandex.partner.core.page;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;

public enum PageType {
    CONTEXT_ON_SITE_CAMPAIGN("context_on_site_campaign", ContextPage::new),
    INTERNAL_CONTEXT_ON_SITE_CAMPAIGN("internal_context_on_site_campaign", InternalContextPage::new),
    MOBILE_APP("mobile_app_settings", MobileAppSettings::new),
    INTERNAL_MOBILE_APP("internal_mobile_app", InternalMobileApp::new);

    private static final Map<String, PageType> LITERAL_MAP = Arrays.stream(values())
            .collect(Collectors.toUnmodifiableMap(PageType::getLiteral, Function.identity()));

    private final String literal;
    private final Supplier<BasePage> constructor;

    PageType(String literal, Supplier<BasePage> constructor) {
        this.literal = literal;
        this.constructor = constructor;
    }

    public static PageType from(String literal) {
        return LITERAL_MAP.get(literal);
    }

    public String getLiteral() {
        return literal;
    }

    public Supplier<BasePage> getConstructor() {
        return constructor;
    }
}
