package ru.yandex.partner.core.props;

import java.util.function.Predicate;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;

/**
 * Универсальный предикат к подготовленным изменениям модели,
 * необходим для преиспользования логики дефолтов и зависимых полей в операциях добавления/обновления
 */
@FunctionalInterface
public interface ChangePredicate<M extends ModelWithId> extends Predicate<PreparedChanges<M>> {
    @Override
    default ChangePredicate<M> negate() {
        return Predicate.super.negate()::test;
    }

    @Override
    default ChangePredicate<M> or(Predicate<? super PreparedChanges<M>> other) {
        return Predicate.super.or(other)::test;
    }

    @Override
    default ChangePredicate<M> and(Predicate<? super PreparedChanges<M>> other) {
        return Predicate.super.and(other)::test;
    }

    static <M extends ModelWithId, V> ChangePredicate<M> havingPropertyValue(
            ModelProperty<? super M, V> property, Predicate<V> valuePredicate) {
        return preparedChanges -> valuePredicate.test(preparedChanges.propertyValue(property));
    }

    static <M extends ModelWithId, V> ChangePredicate<M> havingPropertyValue(
            ModelProperty<? super M, V> property, V requiredValue) {
        return preparedChanges -> requiredValue.equals(preparedChanges.propertyValue(property));
    }
}
