package ru.yandex.partner.core.queue;

public abstract class AbstractTask<P extends TaskPayload, R> implements Task<P, R> {

    private final P payload;
    private final TaskData savedTaskData;

    public AbstractTask(P payload, TaskData savedTaskData) {
        this.payload = payload;
        this.savedTaskData = savedTaskData;
    }

    protected TaskData getSavedTaskData() {
        return savedTaskData;
    }

    protected P getPayload() {
        return payload;
    }
}
