package ru.yandex.partner.core.queue;

import java.io.IOException;

import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.ObjectMapper;

public class JsonTaskPayload implements TaskPayload {
    private final ObjectMapper objectMapper;
    private final int typeId;
    private final Object payload;
    private final Long groupId;

    public JsonTaskPayload(TaskType taskType, Object payload) {
        this(new ObjectMapper(), taskType, payload, null);
    }

    public JsonTaskPayload(ObjectMapper objectMapper, TaskType taskType, Object payload) {
        this(objectMapper, taskType, payload, null);
    }

    public JsonTaskPayload(ObjectMapper objectMapper,
                           TaskType taskType,
                           Object payload,
                           @Nullable Long groupId) {
        this.objectMapper = objectMapper;
        this.typeId = taskType.getTypeId();
        this.payload = payload;
        this.groupId = groupId;
    }

    @Override
    public String serializeParams() {
        try {
            return objectMapper.writeValueAsString(payload);
        } catch (IOException exception) {
            throw new RuntimeException("Failed to serialize Payload", exception);
        }
    }

    @Override
    public int getTypeId() {
        return typeId;
    }

    @Override
    public Long getGroupId() {
        return groupId;
    }
}
