package ru.yandex.partner.core.queue;

import java.time.LocalDateTime;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.multistate.queue.TaskMultistate;

public class TaskData implements ModelWithId {

    private Long id;
    private TaskMultistate multistate;
    private LocalDateTime addDt;
    private LocalDateTime startDt;
    private LocalDateTime endDt;
    private int typeId;
    private Long groupId;
    private String params; // client side
    private Long userId;
    private String log;
    private String errorData; // client side
    private String result; //client side
    private int tries;
    private String grabbedBy;
    private LocalDateTime grabbedAt;
    private LocalDateTime grabbedUntil;

    private TaskData(Builder builder) {
        setId(builder.id);
        setMultistate(builder.multistate);
        setAddDt(builder.addDt);
        setStartDt(builder.startDt);
        setEndDt(builder.endDt);
        setTypeId(builder.typeId);
        setGroupId(builder.groupId);
        setParams(builder.params);
        setUserId(builder.userId);
        setLog(builder.log);
        setErrorData(builder.errorData);
        setResult(builder.result);
        setTries(builder.tries);
        setGrabbedBy(builder.grabbedBy);
        setGrabbedAt(builder.grabbedAt);
        setGrabbedUntil(builder.grabbedUntil);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public TaskMultistate getMultistate() {
        return multistate;
    }

    public void setMultistate(TaskMultistate multistate) {
        this.multistate = multistate;
    }

    public LocalDateTime getAddDt() {
        return addDt;
    }

    public void setAddDt(LocalDateTime addDt) {
        this.addDt = addDt;
    }

    public LocalDateTime getStartDt() {
        return startDt;
    }

    public void setStartDt(LocalDateTime startDt) {
        this.startDt = startDt;
    }

    public LocalDateTime getEndDt() {
        return endDt;
    }

    public void setEndDt(LocalDateTime endDt) {
        this.endDt = endDt;
    }

    public int getTypeId() {
        return typeId;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public String getParams() {
        return params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getLog() {
        return log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public String getErrorData() {
        return errorData;
    }

    public void setErrorData(String errorData) {
        this.errorData = errorData;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public int getTries() {
        return tries;
    }

    public void setTries(int tries) {
        this.tries = tries;
    }

    public void incrementTries() {
        this.tries += 1;
    }

    public String getGrabbedBy() {
        return grabbedBy;
    }

    public void setGrabbedBy(String grabbedBy) {
        this.grabbedBy = grabbedBy;
    }

    public LocalDateTime getGrabbedAt() {
        return grabbedAt;
    }

    public void setGrabbedAt(LocalDateTime grabbedAt) {
        this.grabbedAt = grabbedAt;
    }

    public LocalDateTime getGrabbedUntil() {
        return grabbedUntil;
    }

    public void setGrabbedUntil(LocalDateTime grabbedUntil) {
        this.grabbedUntil = grabbedUntil;
    }

    @Override
    public String toString() {
        return "TaskData{" +
                "id=" + id +
                ", multistate=" + multistate +
                ", addDt=" + addDt +
                ", startDt=" + startDt +
                ", endDt=" + endDt +
                ", typeId=" + typeId +
                ", groupId=" + groupId +
                ", params='" + params + '\'' +
                ", userId=" + userId +
                ", log='" + log + '\'' +
                ", errorData='" + errorData + '\'' +
                ", result='" + result + '\'' +
                ", tries=" + tries +
                ", grabbedBy='" + grabbedBy + '\'' +
                ", grabbedAt=" + grabbedAt +
                ", grabbedUntil=" + grabbedUntil +
                '}';
    }


    public static final class Builder {
        private Long id;
        private TaskMultistate multistate;
        private LocalDateTime addDt;
        private LocalDateTime startDt;
        private LocalDateTime endDt;
        private int typeId;
        private Long groupId;
        private String params;
        private Long userId;
        private String log;
        private String errorData;
        private String result;
        private Integer tries;
        private String grabbedBy;
        private LocalDateTime grabbedAt;
        private LocalDateTime grabbedUntil;

        public Builder() {
        }

        public Builder withId(Long id) {
            this.id = id;
            return this;
        }

        public Builder withMultistate(TaskMultistate multistate) {
            this.multistate = multistate;
            return this;
        }

        public Builder withAddDt(LocalDateTime addDt) {
            this.addDt = addDt;
            return this;
        }

        public Builder withStartDt(LocalDateTime startDt) {
            this.startDt = startDt;
            return this;
        }

        public Builder withEndDt(LocalDateTime endDt) {
            this.endDt = endDt;
            return this;
        }

        public Builder withTypeId(int typeId) {
            this.typeId = typeId;
            return this;
        }

        public Builder withGroupId(Long groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder withParams(String params) {
            this.params = params;
            return this;
        }

        public Builder withUserId(Long userId) {
            this.userId = userId;
            return this;
        }

        public Builder withLog(String log) {
            this.log = log;
            return this;
        }

        public Builder withErrorData(String errorData) {
            this.errorData = errorData;
            return this;
        }

        public Builder withResult(String result) {
            this.result = result;
            return this;
        }

        public Builder withTries(Integer tries) {
            this.tries = tries;
            return this;
        }

        public Builder withGrabbedBy(String grabbedBy) {
            this.grabbedBy = grabbedBy;
            return this;
        }

        public Builder withGrabbedAt(LocalDateTime grabbedAt) {
            this.grabbedAt = grabbedAt;
            return this;
        }

        public Builder withGrabbedUntil(LocalDateTime grabbedUntil) {
            this.grabbedUntil = grabbedUntil;
            return this;
        }

        public TaskData build() {
            return new TaskData(this);
        }
    }
}
