package ru.yandex.partner.core.queue;

import javax.annotation.Nullable;

public class TaskExecutionResult {
    private final Type type;
    private final Object result;
    private final String errorMessage;

    private TaskExecutionResult(Type type, Object result, String errorMessage) {
        this.type = type;
        this.result = result;
        this.errorMessage = errorMessage;
    }

    public static TaskExecutionResult success(Object result) {
        return new TaskExecutionResult(Type.SUCCESS, result, null);
    }

    public static TaskExecutionResult failure(Object result) {
        return new TaskExecutionResult(Type.FAILURE, result, null);
    }

    public static TaskExecutionResult failure(String errorMessage) {
        return new TaskExecutionResult(Type.FAILURE, null, errorMessage);
    }

    public static TaskExecutionResult failure(Object result, String errorMessage) {
        return new TaskExecutionResult(Type.FAILURE, result, errorMessage);
    }

    public Type getType() {
        return type;
    }

    public @Nullable Object getResult() {
        return result;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public boolean isSuccess() {
        return this.type == Type.SUCCESS;
    }

    public boolean isFailure() {
        return this.type == Type.FAILURE;
    }

    public enum Type {
        SUCCESS,
        FAILURE
    }
}
