package ru.yandex.partner.core.queue;

import java.time.Duration;

import ru.yandex.partner.libs.i18n.GettextMsg;

public interface TaskFactory<T extends Task<?, ?>> {
    Class<T> getTaskClass();

    int getTypeId();

    T fromTaskData(TaskData taskData);

    int getMaxTries();

    Duration getTryAfter();

    boolean isAllowConcurrentExecution();

    GettextMsg getTitle();
}
