package ru.yandex.partner.core.role;

import java.util.Objects;
import java.util.Set;

import ru.yandex.partner.libs.i18n.GettextMsg;

import static com.google.common.base.Preconditions.checkNotNull;

public class Role {
    private final long roleId;
    private final GettextMsg nameMsg;
    private final Boolean internal;
    private final long group;
    private final Set<String> relatedPageAccessor;
    private final Boolean viewer;
    private final Set<Role> conflictRoleForSet;
    private final Set<Role> requiredRoleForSet;
    private final Boolean assessorApplicable;
    private final Boolean allExternal;

    @SuppressWarnings("checkstyle:parameternumber")
    public Role(long roleId,
                GettextMsg nameMsg,
                Boolean internal,
                long group,
                Set<String> relatedPageAccessor,
                Boolean viewer,
                Set<Role> conflictRoleForSet,
                Set<Role> requiredRoleForSet,
                Boolean assessorApplicable,
                Boolean allExternal) {
        checkNotNull(nameMsg);
        this.roleId = roleId;
        this.nameMsg = nameMsg;
        this.group = group;
        this.relatedPageAccessor = relatedPageAccessor;
        this.conflictRoleForSet = conflictRoleForSet;
        this.requiredRoleForSet = requiredRoleForSet;
        this.assessorApplicable = assessorApplicable;
        this.allExternal        = allExternal;

        if (viewer == null) {
            this.viewer = false;
        } else {
            this.viewer = viewer;
        }

        if (internal == null) {
            this.internal = false;
        } else {
            this.internal = internal;
        }
    }

    public long getRoleId() {
        return this.roleId;
    }

    public GettextMsg getNameMsg() {
        return this.nameMsg;
    }

    public Boolean getInternal() {
        return this.internal;
    }

    public long getGroup() {
        return this.group;
    }

    public Set<String> getRelatedPageAccessor() {
        return this.relatedPageAccessor;
    }

    public Boolean getViewer() {
        return this.viewer;
    }

    public Set<Role> getConflictRoleForSet() {
        return this.conflictRoleForSet;
    }

    public Set<Role> getRequiredRoleForSet() {
        return this.requiredRoleForSet;
    }

    public boolean isInternal() {
        return internal != null && internal;
    }

    public boolean isViewer() {
        return viewer != null && viewer;
    }

    public boolean isAssessorApplicable() {
        return assessorApplicable != null && assessorApplicable;
    }

    public Boolean getAssessorApplicable() {
        return assessorApplicable;
    }

    public Boolean getAllExternal() {
        return allExternal;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Role)) {
            return false;
        }
        Role role = (Role) o;
        return roleId == role.roleId &&
                group == role.group &&
                Objects.equals(nameMsg, role.nameMsg) &&
                Objects.equals(internal, role.internal) &&
                Objects.equals(relatedPageAccessor, role.relatedPageAccessor) &&
                Objects.equals(viewer, role.viewer) &&
                Objects.equals(conflictRoleForSet, role.conflictRoleForSet) &&
                Objects.equals(requiredRoleForSet, role.requiredRoleForSet) &&
                Objects.equals(assessorApplicable, role.assessorApplicable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(roleId);
    }

    @Override
    public String toString() {
        return "Role{" +
                "roleId=" + roleId +
                ", nameMsg='" + nameMsg + '\'' +
                ", internal=" + internal +
                ", group=" + group +
                ", relatedPageAccessor=" + relatedPageAccessor +
                ", viewer=" + viewer +
                ", conflictRoleForSet=" + conflictRoleForSet +
                ", requiredRoleForSet=" + requiredRoleForSet +
                ", assessorApplicable=" + assessorApplicable +
                '}';
    }
}
