package ru.yandex.partner.core.block;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;

class BlockUniqueIdConverterTest {

    @Test
    void convertToPublicId() {
        assertEquals("R-A-400123-3", BlockUniqueIdConverter.convertToPublicId(3356474998787L));
        assertThrows(IllegalArgumentException.class,
                () -> BlockUniqueIdConverter.convertToPublicId(9187346596310810627L));

    }

    @Test
    void convertToUniqueIdFromPublicId() {
        assertEquals(3356474998787L, BlockUniqueIdConverter.convertToUniqueId("R-A-400123-3"));

        assertThrows(IllegalArgumentException.class,
                () -> BlockUniqueIdConverter.convertToUniqueId("R-A-400123"));

        assertThrows(IllegalArgumentException.class,
                () -> BlockUniqueIdConverter.convertToUniqueId("R-A-400123-3-3"));

        assertThrows(IllegalArgumentException.class,
                () -> BlockUniqueIdConverter.convertToUniqueId("UNKNOWN-400123"));
    }

    @Test
    void convertToUniqueId() {
        assertEquals(
                720578014798151686L,
                BlockUniqueIdConverter.convertToUniqueId(20L, 247290L, 6L)
        );

        assertEquals(
                Long.MAX_VALUE,
                BlockUniqueIdConverter.convertToUniqueId(255L, 4294967295L, 8388607L)
        );

        assertEquals(
                0L,
                BlockUniqueIdConverter.convertToUniqueId(0L, 0L, 0L)
        );

        assertThrows(IllegalArgumentException.class,
                () -> BlockUniqueIdConverter.convertToUniqueId(-1L, 1L, 1L));

        assertThrows(IllegalArgumentException.class,
                () -> BlockUniqueIdConverter.convertToUniqueId(1L, -1L, 1L));

        assertThrows(IllegalArgumentException.class,
                () -> BlockUniqueIdConverter.convertToUniqueId(1L, 1L, -1L));

        assertThrows(IllegalArgumentException.class,
                () -> BlockUniqueIdConverter.convertToUniqueId(256L, 1L, 1L));

        assertThrows(IllegalArgumentException.class,
                () -> BlockUniqueIdConverter.convertToUniqueId(1L, 4294967296L, 1L));

        assertThrows(IllegalArgumentException.class,
                () -> BlockUniqueIdConverter.convertToUniqueId(1L, 1L, 8388608L));
    }

    @Test
    void pageIdFromUniqueId() {
        assertEquals(
                247290L,
                BlockUniqueIdConverter.pageIdFromUniqueId(720578014798151686L)
        );

        assertEquals(
                4294967295L,
                BlockUniqueIdConverter.pageIdFromUniqueId(Long.MAX_VALUE)
        );

        assertEquals(
                0L,
                BlockUniqueIdConverter.pageIdFromUniqueId(0L)
        );

        assertThrows(IllegalArgumentException.class,
                () -> BlockUniqueIdConverter.convertToUniqueId(1L, 1L, 8388608L));

        assertThrows(IllegalArgumentException.class,
                () -> BlockUniqueIdConverter.pageIdFromUniqueId(-1L));
    }

    @Test
    void blockIdFromUniqueId() {
        assertEquals(
                6L,
                BlockUniqueIdConverter.blockIdFromUniqueId(720578014798151686L)
        );

        assertEquals(
                8388607L,
                BlockUniqueIdConverter.blockIdFromUniqueId(Long.MAX_VALUE)
        );

        assertEquals(
                0L,
                BlockUniqueIdConverter.blockIdFromUniqueId(0L)
        );

        assertThrows(IllegalArgumentException.class,
                () -> BlockUniqueIdConverter.blockIdFromUniqueId(-1L));

    }

}
