# -*- coding: utf-8 -*-

from ut_utils import TestModelGeneratorResult, compare_dirs
from yatest.common import source_path


class TestCoreModel(TestModelGeneratorResult):
    conf_dir = source_path("partner/java/libs/core-model/src/main/model-conf")
    generated_dir = source_path("partner/java/libs/core-model/src/generated/java")

    def test_model(self):
        result, message = compare_dirs(self.generated_dir, self.tmpdir)
        assert result, message + ", please regenerate models or update .conf files"
