CREATE TABLE IF NOT EXISTS `all_blocks` (
    `id_autoincrement` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `page_id` BIGINT UNSIGNED NOT NULL,
    `id` INT UNSIGNED NOT NULL,
    `model` VARCHAR(64) NOT NULL,
    `caption` VARCHAR(255) NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL,
    `site_version` VARCHAR(64),
    `adfox_block` BOOLEAN,
    `mobile_block_type` VARCHAR(64),
    `video_block_type` TINYINT UNSIGNED,
    `disposition_id` TINYINT UNSIGNED,
    `place_id` INT UNSIGNED,
    `category_id` BIGINT UNSIGNED,
    PRIMARY KEY (`id_autoincrement`),
    UNIQUE INDEX `uniq_all_blocks__model_page_id_id` (`model`, `page_id`, `id`),
    INDEX `all_blocks__adfox_block` (`adfox_block`)
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'