CREATE OR REPLACE
VIEW `all_blocks_view` (
    `adfox_block`,
    `caption`,
    `category_id`,
    `disposition_id`,
    `id`,
    `mobile_block_type`,
    `model`,
    `multistate`,
    `page_id`,
    `place_id`,
    `site_version`,
    `video_block_type`
) AS
SELECT
    NULL AS `adfox_block`,
    `context_on_site_adblock`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `context_on_site_adblock`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'context_on_site_adblock' AS `model`,
    `context_on_site_adblock`.`multistate` AS `multistate`,
    `context_on_site_adblock`.`page_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `context_on_site_adblock`
UNION ALL
SELECT
    NULL AS `adfox_block`,
    `context_on_site_direct`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `context_on_site_direct`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'context_on_site_direct' AS `model`,
    `context_on_site_direct`.`multistate` AS `multistate`,
    `context_on_site_direct`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `context_on_site_direct`
WHERE (
    `context_on_site_direct`.`active` = '1'
)
UNION ALL
SELECT
    `context_on_site_natural`.`adfox_block` AS `adfox_block`,
    `context_on_site_natural`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `context_on_site_natural`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'context_on_site_natural' AS `model`,
    `context_on_site_natural`.`multistate` AS `multistate`,
    `context_on_site_natural`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    `context_on_site_natural`.`site_version` AS `site_version`,
    NULL AS `video_block_type`
FROM `context_on_site_natural`
UNION ALL
SELECT
    `context_on_site_rtb`.`adfox_block` AS `adfox_block`,
    `context_on_site_rtb`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `context_on_site_rtb`.`id` AS `id`,
    `context_on_site_rtb`.`block_type` AS `mobile_block_type`,
    `context_on_site_rtb`.`model` AS `model`,
    `context_on_site_rtb`.`multistate` AS `multistate`,
    `context_on_site_rtb`.`campaign_id` AS `page_id`,
    `context_on_site_rtb`.`place_id` AS `place_id`,
    `context_on_site_rtb`.`site_version` AS `site_version`,
    NULL AS `video_block_type`
FROM `context_on_site_rtb`
WHERE (
    `context_on_site_rtb`.`active` = '1'
)
UNION ALL
SELECT
    NULL AS `adfox_block`,
    `context_on_site_stripe`.`title` AS `caption`,
    NULL AS `category_id`,
    `context_on_site_stripe`.`disposition_id` AS `disposition_id`,
    `context_on_site_stripe`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'context_on_site_stripe' AS `model`,
    `context_on_site_stripe`.`multistate` AS `multistate`,
    `context_on_site_stripe`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `context_on_site_stripe`
UNION ALL
SELECT
    `internal_context_on_site_content`.`adfox_block` AS `adfox_block`,
    `internal_context_on_site_content`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `internal_context_on_site_content`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'internal_context_on_site_content' AS `model`,
    `internal_context_on_site_content`.`multistate` AS `multistate`,
    `internal_context_on_site_content`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    `internal_context_on_site_content`.`site_version` AS `site_version`,
    NULL AS `video_block_type`
FROM `internal_context_on_site_content`
UNION ALL
SELECT
    NULL AS `adfox_block`,
    `internal_context_on_site_direct`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `internal_context_on_site_direct`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'internal_context_on_site_direct' AS `model`,
    `internal_context_on_site_direct`.`multistate` AS `multistate`,
    `internal_context_on_site_direct`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `internal_context_on_site_direct`
WHERE (
    `internal_context_on_site_direct`.`active` = '1'
)
UNION ALL
SELECT
    `internal_context_on_site_natural`.`adfox_block` AS `adfox_block`,
    `internal_context_on_site_natural`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `internal_context_on_site_natural`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'internal_context_on_site_natural' AS `model`,
    `internal_context_on_site_natural`.`multistate` AS `multistate`,
    `internal_context_on_site_natural`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    `internal_context_on_site_natural`.`site_version` AS `site_version`,
    NULL AS `video_block_type`
FROM `internal_context_on_site_natural`
UNION ALL
SELECT
    NULL AS `adfox_block`,
    `internal_context_on_site_stripe`.`title` AS `caption`,
    NULL AS `category_id`,
    `internal_context_on_site_stripe`.`disposition_id` AS `disposition_id`,
    `internal_context_on_site_stripe`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'internal_context_on_site_stripe' AS `model`,
    `internal_context_on_site_stripe`.`multistate` AS `multistate`,
    `internal_context_on_site_stripe`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `internal_context_on_site_stripe`
UNION ALL
SELECT
    NULL AS `adfox_block`,
    `internal_search_on_site_direct`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `internal_search_on_site_direct`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'internal_search_on_site_direct' AS `model`,
    `internal_search_on_site_direct`.`multistate` AS `multistate`,
    `internal_search_on_site_direct`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `internal_search_on_site_direct`
UNION ALL
SELECT
    NULL AS `adfox_block`,
    `internal_search_on_site_premium`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `internal_search_on_site_premium`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'internal_search_on_site_premium' AS `model`,
    `internal_search_on_site_premium`.`multistate` AS `multistate`,
    `internal_search_on_site_premium`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `internal_search_on_site_premium`
UNION ALL
SELECT
    NULL AS `adfox_block`,
    `search_on_site_direct`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `search_on_site_direct`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'search_on_site_direct' AS `model`,
    `search_on_site_direct`.`multistate` AS `multistate`,
    `search_on_site_direct`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `search_on_site_direct`
UNION ALL
SELECT
    NULL AS `adfox_block`,
    `search_on_site_premium`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `search_on_site_premium`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'search_on_site_premium' AS `model`,
    `search_on_site_premium`.`multistate` AS `multistate`,
    `search_on_site_premium`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `search_on_site_premium`
UNION ALL
SELECT
    `ssp_context_on_site_rtb`.`adfox_block` AS `adfox_block`,
    `ssp_context_on_site_rtb`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `ssp_context_on_site_rtb`.`id` AS `id`,
    `ssp_context_on_site_rtb`.`block_type` AS `mobile_block_type`,
    'ssp_context_on_site_rtb' AS `model`,
    `ssp_context_on_site_rtb`.`multistate` AS `multistate`,
    `ssp_context_on_site_rtb`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `ssp_context_on_site_rtb`
UNION ALL
SELECT
    `ssp_mobile_app_rtb`.`adfox_block` AS `adfox_block`,
    `ssp_mobile_app_rtb`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `ssp_mobile_app_rtb`.`id` AS `id`,
    `ssp_mobile_app_rtb`.`block_type` AS `mobile_block_type`,
    'ssp_mobile_app_rtb' AS `model`,
    `ssp_mobile_app_rtb`.`multistate` AS `multistate`,
    `ssp_mobile_app_rtb`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `ssp_mobile_app_rtb`
UNION ALL
SELECT
    `ssp_video_an_site_rtb`.`adfox_block` AS `adfox_block`,
    `ssp_video_an_site_rtb`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `ssp_video_an_site_rtb`.`id` AS `id`,
    `ssp_video_an_site_rtb`.`block_type` AS `mobile_block_type`,
    'ssp_video_an_site_rtb' AS `model`,
    `ssp_video_an_site_rtb`.`multistate` AS `multistate`,
    `ssp_video_an_site_rtb`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `ssp_video_an_site_rtb`
UNION ALL
SELECT
    `video_an_site_fullscreen`.`adfox_block` AS `adfox_block`,
    `video_an_site_fullscreen`.`caption` AS `caption`,
    `video_an_site_fullscreen`.`category_id` AS `category_id`,
    NULL AS `disposition_id`,
    `video_an_site_fullscreen`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'video_an_site_fullscreen' AS `model`,
    `video_an_site_fullscreen`.`multistate` AS `multistate`,
    `video_an_site_fullscreen`.`page_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    `video_an_site_fullscreen`.`type` AS `video_block_type`
FROM `video_an_site_fullscreen`
UNION ALL
SELECT
    `video_an_site_inpage`.`adfox_block` AS `adfox_block`,
    `video_an_site_inpage`.`caption` AS `caption`,
    `video_an_site_inpage`.`category_id` AS `category_id`,
    NULL AS `disposition_id`,
    `video_an_site_inpage`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'video_an_site_inpage' AS `model`,
    `video_an_site_inpage`.`multistate` AS `multistate`,
    `video_an_site_inpage`.`page_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    `video_an_site_inpage`.`type` AS `video_block_type`
FROM `video_an_site_inpage`
UNION ALL
SELECT
    `video_an_site_instream`.`adfox_block` AS `adfox_block`,
    `video_an_site_instream`.`caption` AS `caption`,
    `video_an_site_instream`.`category_id` AS `category_id`,
    NULL AS `disposition_id`,
    `video_an_site_instream`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'video_an_site_instream' AS `model`,
    `video_an_site_instream`.`multistate` AS `multistate`,
    `video_an_site_instream`.`page_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    `video_an_site_instream`.`type` AS `video_block_type`
FROM `video_an_site_instream`