CREATE TABLE IF NOT EXISTS `all_pages` (
    `id` BIGINT UNSIGNED NOT NULL,
    `model` VARCHAR(255) NOT NULL DEFAULT '',
    `page_id` INT UNSIGNED,
    `caption` VARCHAR(255) NOT NULL DEFAULT '',
    `domain_id` BIGINT UNSIGNED NOT NULL,
    `source_id` BIGINT UNSIGNED,
    `domain` VARCHAR(255) NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL,
    `is_internal` BOOLEAN NOT NULL DEFAULT '0',
    `is_working` BOOLEAN NOT NULL DEFAULT '0',
    `is_stopped` BOOLEAN NOT NULL DEFAULT '0',
    `is_deleted` BOOLEAN NOT NULL DEFAULT '0',
    `is_readonly` BOOLEAN NOT NULL DEFAULT '0',
    `is_blocked` BOOLEAN NOT NULL DEFAULT '0',
    `is_rejected` BOOLEAN NOT NULL DEFAULT '0',
    `is_protected` BOOLEAN NOT NULL DEFAULT '0',
    `is_balance_registered` BOOLEAN NOT NULL DEFAULT '0',
    `product_type` VARCHAR(255) NOT NULL DEFAULT '',
    `owner_id` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `login` VARCHAR(40) NOT NULL DEFAULT '',
    `client_id` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `business_unit` BOOLEAN NOT NULL DEFAULT '0',
    `create_date` DATETIME NOT NULL,
    `update_time` DATETIME NOT NULL,
    `send_time` DATETIME NOT NULL,
    PRIMARY KEY (`id`, `model`),
    INDEX `all_pages__page_id` (`page_id`),
    INDEX `all_pages__owner_id` (`owner_id`),
    INDEX `all_pages__client_id` (`client_id`),
    INDEX `all_pages__domain_id` (`domain_id`)
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'