CREATE TABLE IF NOT EXISTS `block_tags_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_page_id` INT UNSIGNED NOT NULL,
    `elem_tag_id` BIGINT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `block_tags_action_log__dt_elem_page_id_elem_tag_id_action` (`dt`, `elem_page_id`, `elem_tag_id`, `action`),
    INDEX `block_tags_action_log__elem_page_id_elem_tag_id_action` (`elem_page_id`, `elem_tag_id`, `action`),
    FOREIGN KEY `fk_block_tags_action_log__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_block_tags_action_log__elem_page_id_elem_tag_id___block_tags` (`elem_page_id`, `elem_tag_id`)
        REFERENCES `block_tags` (`page_id`, `tag_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'