CREATE TABLE IF NOT EXISTS `business_blocks` (
    `rule_id` BIGINT UNSIGNED NOT NULL,
    `page_id` INT UNSIGNED NOT NULL,
    `block_id` INT UNSIGNED NOT NULL,
    `block_accessor` VARCHAR(255) NOT NULL,
    `is_deleted` BOOLEAN NOT NULL DEFAULT '0',
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `update_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    `send_time` DATETIME NOT NULL DEFAULT '1970-01-01 03:00:00',
    PRIMARY KEY (`rule_id`, `page_id`, `block_id`),
    FOREIGN KEY `fk_business_blocks__rule_id___business_rules__rule_id` (`rule_id`)
        REFERENCES `business_rules` (`rule_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'