CREATE TABLE IF NOT EXISTS `business_rules_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_rule_id` BIGINT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `business_rules_action_log__dt_elem_rule_id_action` (`dt`, `elem_rule_id`, `action`),
    INDEX `business_rules_action_log__elem_rule_id_action` (`elem_rule_id`, `action`),
    FOREIGN KEY `fk_business_rules_action_log__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_business_rules_action_log__elem_rule_id___business_rules__ru` (`elem_rule_id`)
        REFERENCES `business_rules` (`rule_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'