CREATE TABLE IF NOT EXISTS `context_on_site_direct` (
    `campaign_id` INT UNSIGNED,
    `id` INT UNSIGNED NOT NULL,
    `caption` VARCHAR(255) NOT NULL DEFAULT '',
    `type` VARCHAR(20) NOT NULL,
    `limit` INT UNSIGNED,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `alternative_code` TEXT NOT NULL DEFAULT '',
    `border_radius` BOOLEAN,
    `favicon` BOOLEAN DEFAULT '0',
    `images_first` BOOLEAN,
    `no_sitelinks` BOOLEAN NOT NULL DEFAULT '0',
    `links_underline` BOOLEAN DEFAULT '1',
    `border_type` VARCHAR(8),
    `site_bg_color` VARCHAR(6) NOT NULL,
    `bg_color` VARCHAR(6),
    `border_color` VARCHAR(6),
    `header_bg_color` VARCHAR(6),
    `sitelinks_color` VARCHAR(6),
    `title_color` VARCHAR(6),
    `text_color` VARCHAR(6),
    `url_color` VARCHAR(6),
    `url_background_color` VARCHAR(6),
    `hover_color` VARCHAR(6),
    `font_family` VARCHAR(15),
    `font_size` VARCHAR(3),
    `title_font_size` TINYINT UNSIGNED,
    `adaptive_width` VARCHAR(4) NOT NULL DEFAULT '',
    `adaptive_height` VARCHAR(4) NOT NULL DEFAULT '',
    `comment` TEXT,
    `is_custom_bk_data` BOOLEAN NOT NULL DEFAULT '0',
    `bk_data` MEDIUMTEXT,
    `pi_id` INT UNSIGNED,
    `active` BOOLEAN NOT NULL DEFAULT '1',
    PRIMARY KEY (`campaign_id`, `id`),
    FOREIGN KEY `fk_context_on_site_direct__campaign_id___context_on_site_campai` (`campaign_id`)
        REFERENCES `context_on_site_campaign` (`page_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'