CREATE TABLE IF NOT EXISTS `context_on_site_mirrors` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `campaign_id` INT UNSIGNED NOT NULL,
    `domain` VARCHAR(64) NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `auto` BOOLEAN NOT NULL DEFAULT '0',
    `create_date` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `waiting_moderation` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_context_on_site_mirrors__campaign_id_domain` (`campaign_id`, `domain`),
    FOREIGN KEY `fk_context_on_site_mirrors__campaign_id___context_on_site_campa` (`campaign_id`)
        REFERENCES `context_on_site_campaign` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8'